<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Build Reports - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    /* Ensure the body takes up the full height of the viewport */
    html, body {
      height: 100%;
      margin: 0;
    }
    /* Content wrapper with padding to prevent overlap with the footer */
    .content-wrapper {
      padding: 20px;
      padding-bottom: 80px; /* Add padding to prevent footer overlap */
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
      border-top: 1px solid #dee2e6; /* Add a border to the top of the footer */
      position: fixed; /* Make the footer sticky */
      bottom: 0; /* Stick it to the bottom */
      left: 0;
      right: 0;
      z-index: 1000; /* Ensure the footer stays above other content */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.01);
    }
    /* Active state for the footer section */
    footer .footer-section.active {
      border-top: 4px solid #ffffff; /* White border to indicate active state */
      box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1); /* Subtle shadow for emphasis */
    }
    /* Report builder styling */
    .audit-list {
      margin-top: 20px;
    }
    .audit-item {
      background-color: #f8f9fa;
      border: 1px solid #dee2e6;
      border-radius: 8px;
      padding: 15px;
      margin-bottom: 10px;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }
    .audit-item:hover {
      background-color: #e9ecef;
    }
    .audit-item input[type="checkbox"] {
      margin-right: 10px;
    }
    .audit-item .audit-details {
      flex-grow: 1;
    }
    .audit-item .audit-details h5 {
      margin: 0;
      font-size: 18px;
    }
    .audit-item .audit-details p {
      margin: 0;
      font-size: 14px;
      color: #6c757d;
    }
    .generate-report-btn {
      margin-top: 20px;
      width: 100%;
    }
    .date-range-picker {
      margin-bottom: 20px;
    }
    .chart-container {
      margin-top: 20px;
    }
  </style>
</head>
<body>
  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          <a class="btn btn-outline-secondary me-2" href="alerts.php">
            <i class="fa-solid fa-bell"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Build Reports Content -->
  <div class="content-wrapper">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <h1 class="text-center mt-3"><?php echo $_SESSION['companyName']; ?></h1>
          <h2 class="mb-4">Build Reports</h2>
          <p>Select one or more completed audits to generate a consolidated report.</p>
          
          <!-- Date Range Picker -->
          <div class="date-range-picker">
            <label for="dateRange">Select Date Range:</label>
            <input type="date" id="startDate">
            <input type="date" id="endDate">
            <button class="btn btn-secondary" onclick="updateReport()">Apply</button>
          </div>

          <div class="audit-list">
            <!-- Audit 1 -->
            <div class="audit-item">
              <input type="checkbox" id="audit1">
              <div class="audit-details">
                <h5>ISO 9001 Compliance Audit</h5>
                <p>Completed on: 2023-10-15</p>
              </div>
            </div>
            <!-- Audit 2 -->
            <div class="audit-item">
              <input type="checkbox" id="audit2">
              <div class="audit-details">
                <h5>ISO 14001 Environmental Audit</h5>
                <p>Completed on: 2023-09-28</p>
              </div>
            </div>
            <!-- Audit 3 -->
            <div class="audit-item">
              <input type="checkbox" id="audit3">
              <div class="audit-details">
                <h5>ISO 45001 Safety Audit</h5>
                <p>Completed on: 2023-08-10</p>
              </div>
            </div>
          </div>
          <button class="btn btn-primary generate-report-btn">
            <i class="fa-solid fa-file-pdf me-2"></i> Generate Report
          </button>

          <!-- Chart Container -->
          <div class="chart-container">
            <canvas id="reportChart"></canvas>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer>
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors</div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Help</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center active">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Sample data for the chart
    const data = {
      labels: ['ISO 9001', 'ISO 14001', 'ISO 45001'],
      datasets: [{
        label: 'Audit Scores',
        data: [85, 90, 78],
        backgroundColor: [
          'rgba(255, 99, 132, 0.2)',
          'rgba(54, 162, 235, 0.2)',
          'rgba(75, 192, 192, 0.2)'
        ],
        borderColor: [
          'rgba(255, 99, 132, 1)',
          'rgba(54, 162, 235, 1)',
          'rgba(75, 192, 192, 1)'
        ],
        borderWidth: 1
      }]
    };

    // Chart configuration
    const config = {
      type: 'bar',
      data: data,
      options: {
        scales: {
          y: {
            beginAtZero: true
          }
        }
      }
    };

    // Initialize the chart
    const reportChart = new Chart(
      document.getElementById('reportChart'),
      config
    );

    // Function to update the report based on the selected date range
    function updateReport() {
      const startDate = document.getElementById('startDate').value;
      const endDate = document.getElementById('endDate').value;
      // Here you would typically fetch new data based on the date range and update the chart
      console.log(`Fetching data from ${startDate} to ${endDate}`);
      // For now, we'll just update the chart with some dummy data
      reportChart.data.datasets[0].data = [Math.random() * 100, Math.random() * 100, Math.random() * 100];
      reportChart.update();
    }
  </script>
</body>
</html>