<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Completed Audits - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Ensure the body takes up the full height of the viewport */
    html, body {
      height: 100%;
      margin: 0;
    }
    /* Content wrapper with padding to prevent overlap with the footer */
    .content-wrapper {
      padding: 20px;
      padding-bottom: 100px; /* Add padding equal to the footer height */
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
      /*height: 100px;  Fixed height for the footer */
      border-top: 1px solid #dee2e6; /* Add a border to the top of the footer */
      position: fixed; /* Make the footer sticky */
      bottom: 0; /* Stick it to the bottom */
      left: 0;
      right: 0;
      z-index: 1000; /* Ensure the footer stays above other content */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.01);
    }
    /* Active state for the footer section */
    footer .footer-section.active {
      border-top: 4px solid #ffffff; /* White border to indicate active state */
      box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1); /* Subtle shadow for emphasis */
    }
    /* Completed Audits table styling */
    .audit-table {
      width: 100%;
      border-collapse: collapse;
    }
    .audit-table th, .audit-table td {
      padding: 12px;
      text-align: left;
      border-bottom: 1px solid #dee2e6;
    }
    .audit-table th {
      background-color: #f8f9fa;
      font-weight: bold;
    }
    .audit-table tr:hover {
      background-color: #f8f9fa;
    }
    .audit-status {
      padding: 4px 8px;
      border-radius: 4px;
      font-size: 14px;
      font-weight: bold;
    }
    .audit-status.completed {
      background-color: #d4edda;
      color: #155724;
    }
    .audit-status.in-progress {
      background-color: #fff3cd;
      color: #856404;
    }
  </style>
</head>
<body>
  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          <a class="btn btn-outline-secondary me-2" href="alerts.php">
            <i class="fa-solid fa-bell"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Completed Audits Content -->
  <div class="content-wrapper">
    <div class="card mb-4">
      <div class="card-header d-flex justify-content-between align-items-center">
        <div>
          <h5 class="mb-0">Completed Audits</h5>
          <small class="text-muted">View and manage your completed audits</small>
        </div>
      </div>
      <div class="card-body">
        <!-- Completed Audits Table -->
        <table class="audit-table">
          <thead>
            <tr>
              <th>Audit Name</th>
              <th>Date</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            <!-- Audit 1 -->
            <tr>
              <td>ISO 9001 Compliance Audit</td>
              <td>2023-10-15</td>
              <td>
                <span class="audit-status completed">Completed</span>
              </td>
              <td>
                <a href="#" class="btn btn-sm btn-outline-primary">
                  <i class="fa-solid fa-eye me-1"></i> View Report
                </a>
                <a href="#" class="btn btn-sm btn-outline-success">
                  <i class="fa-solid fa-download me-1"></i> Download
                </a>
              </td>
            </tr>
            <!-- Audit 2 -->
            <tr>
              <td>ISO 14001 Environmental Audit</td>
              <td>2023-09-28</td>
              <td>
                <span class="audit-status completed">Completed</span>
              </td>
              <td>
                <a href="#" class="btn btn-sm btn-outline-primary">
                  <i class="fa-solid fa-eye me-1"></i> View Report
                </a>
                <a href="#" class="btn btn-sm btn-outline-success">
                  <i class="fa-solid fa-download me-1"></i> Download
                </a>
              </td>
            </tr>
            <!-- Audit 3 -->
            <tr>
              <td>ISO 45001 Safety Audit</td>
              <td>2023-08-10</td>
              <td>
                <span class="audit-status completed">Completed</span>
              </td>
              <td>
                <a href="#" class="btn btn-sm btn-outline-primary">
                  <i class="fa-solid fa-eye me-1"></i> View Report
                </a>
                <a href="#" class="btn btn-sm btn-outline-success">
                  <i class="fa-solid fa-download me-1"></i> Download
                </a>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer>
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors</div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Tutorials</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center active">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>