<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Customize MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Ensure the body takes up the full height of the viewport */
    html, body {
      height: 100%;
      margin: 0;
    }
    /* Content wrapper with padding to prevent overlap with the footer */
    .content-wrapper {
      padding: 20px;
      padding-bottom: 100px; /* Add padding equal to the footer height */
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
      border-top: 1px solid #dee2e6; /* Add a border to the top of the footer */
      position: fixed; /* Make the footer sticky */
      bottom: 0; /* Stick it to the bottom */
      left: 0;
      right: 0;
      z-index: 1000; /* Ensure the footer stays above other content */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.01);
    }
    /* Active state for the footer section */
    footer .footer-section.active {
      border-top: 4px solid #ffffff; /* White border to indicate active state */
      box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1); /* Subtle shadow for emphasis */
    }
    /* Custom dropdown styling */
    .dropdown-menu {
      min-width: 250px; /* Set a minimum width for the dropdown */
    }
    .dropdown-item {
      display: flex;
      align-items: center;
      padding: 10px;
    }
    .dropdown-item i {
      margin-right: 10px;
    }
    .dropdown-item.unread {
      background-color: #f8f9fa; /* Highlight unread notifications */
    }
  </style>
</head>
<body>
  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          <!-- Alerts Dropdown -->
          <div class="dropdown">
            <a class="btn btn-outline-secondary me-2 dropdown-toggle" href="#" role="button" id="alertsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
              <i class="fa-solid fa-bell"></i>
              <span class="badge bg-danger">3</span> <!-- Notification badge -->
            </a>
            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="alertsDropdown">
              <!-- Unread Notifications -->
              <li>
                <a class="dropdown-item unread" href="#">
                  <i class="fa-solid fa-envelope"></i>
                  <div>
                    <strong>New Message</strong>
                    <small class="text-muted">You have a new message from John Doe.</small>
                  </div>
                </a>
              </li>
              <li>
                <a class="dropdown-item unread" href="#">
                  <i class="fa-solid fa-triangle-exclamation"></i>
                  <div>
                    <strong>Urgent Alert</strong>
                    <small class="text-muted">Action required for audit #123.</small>
                  </div>
                </a>
              </li>
              <!-- Read Notifications -->
              <li>
                <a class="dropdown-item" href="#">
                  <i class="fa-solid fa-check-circle"></i>
                  <div>
                    <strong>Task Completed</strong>
                    <small class="text-muted">Audit #456 has been completed.</small>
                  </div>
                </a>
              </li>
              <li><hr class="dropdown-divider"></li>
              <li>
                <a class="dropdown-item text-center" href="alerts.php">
                  <i class="fa-solid fa-bell"></i> View All Alerts
                </a>
              </li>
            </ul>
          </div>
          <!-- Logout Button -->
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Customize MyISOPro Content -->
  <div class="content-wrapper">
    <div class="card mb-4">
      <div class="card-header d-flex justify-content-between align-items-center">
        <div>
          <h5 class="mb-0">Customize MyISOPro</h5>
          <small class="text-muted">Personalize your MyISOPro experience</small>
        </div>
      </div>
      <div class="card-body">
        <!-- Company Information Section -->
        <div class="mb-5">
          <h6 class="mb-3">Company Information</h6>
          <form>
            <div class="row">
              <div class="col-md-6 mb-3">
                <label for="companyName" class="form-label">Company Name</label>
                <input type="text" class="form-control" id="companyName" value="MyISOPro Inc.">
              </div>
              <div class="col-md-6 mb-3">
                <label for="companyAddress" class="form-label">Address</label>
                <input type="text" class="form-control" id="companyAddress" value="123 ISO Street, Quality City">
              </div>
              <div class="col-md-6 mb-3">
                <label for="companyEmail" class="form-label">Email</label>
                <input type="email" class="form-control" id="companyEmail" value="info@myisopro.com">
              </div>
              <div class="col-md-6 mb-3">
                <label for="companyPhone" class="form-label">Phone</label>
                <input type="tel" class="form-control" id="companyPhone" value="+1 (123) 456-7890">
              </div>
            </div>
          </form>
        </div>

        <!-- Contact Person/Admin Section -->
        <div class="mb-5">
          <h6 class="mb-3">Contact Person / Admin</h6>
          <form>
            <div class="row">
              <div class="col-md-6 mb-3">
                <label for="contactName" class="form-label">Name</label>
                <input type="text" class="form-control" id="contactName" value="John Doe">
              </div>
              <div class="col-md-6 mb-3">
                <label for="contactRole" class="form-label">Role</label>
                <input type="text" class="form-control" id="contactRole" value="Admin">
              </div>
              <div class="col-md-6 mb-3">
                <label for="contactEmail" class="form-label">Email</label>
                <input type="email" class="form-control" id="contactEmail" value="johndoe@myisopro.com">
              </div>
              <div class="col-md-6 mb-3">
                <label for="contactPhone" class="form-label">Phone</label>
                <input type="tel" class="form-control" id="contactPhone" value="+1 (987) 654-3210">
              </div>
            </div>
          </form>
        </div>

        <!-- Selection Rows -->
        <div class="row mt-4">
          <!-- Site Type -->
          <div class="col-md-4 border p-3 rounded">
            <label class="form-label"><strong>Site Type</strong></label><br>
            <div class="form-check">
              <input class="form-check-input" type="radio" id="singleSite" name="site_type" value="single" checked>
              <label class="form-check-label" for="singleSite">Single Site</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="radio" id="multipleSites" name="site_type" value="multiple" disabled>
              <label class="form-check-label text-muted" for="multipleSites">Multiple Sites (coming soon)</label>
            </div>
          </div>

          <!-- Audit Type -->
          <div class="col-md-4 border p-3 rounded">
            <label class="form-label"><strong>Audit Type</strong></label><br>
            <div class="form-check">
              <input class="form-check-input" type="radio" id="internalAudit" name="audit_type" value="internal" checked>
              <label class="form-check-label" for="internalAudit">ISO Internal Audit</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="radio" id="supplyChainAudit" name="audit_type" value="supplyChain" disabled>
              <label class="form-check-label text-muted" for="supplyChainAudit">Supply Chain</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="radio" id="RegulatoryComplianceEvaluation" name="audit_type" value="RegulatoryComplianceEvaluation" disabled style="opacity: 1; pointer-events: none;">
              <label class="form-check-label" for="RegulatoryComplianceEvaluation">Regulatory Compliance Evaluation</label>
            </div>
          </div>

          <!-- Standards -->
          <div class="col-md-4 border p-3 rounded">
            <label class="form-label"><strong>Standards</strong></label><br>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="iso9001" name="standards[]" value="ISO9001 Quality" checked>
              <label class="form-check-label text-muted" for="iso9001">ISO9001 Quality</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="iso14001" name="standards[]" value="ISO14001 Environmental" disabled>
              <label class="form-check-label text-muted" for="iso14001">ISO14001 Environmental</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="iso27001" name="standards[]" value="ISO27001 Quality" disabled>
              <label class="form-check-label text-muted" for="iso27001">ISO 27001 International</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="iso45001" name="standards[]" value="ISO 45001 Safety" disabled>
              <label class="form-check-label text-muted" for="iso45001">ISO 45001 Safety</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="customStandard" name="standards[]" value="Custom" disabled>
              <label class="form-check-label text-muted" for="customStandard">Integrated Management System IMS</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="customStandard" name="standards[]" value="Custom" disabled>
              <label class="form-check-label text-muted" for="customStandard">Custom</label>
            </div>
          </div>
        </div>

        <!-- EA Code Selector -->
        <div class="container mt-5">
          <h3>Select an EA Code</h3>
          <div class="mt-3">
            <select class="form-select" id="eaCodeSelect">
              <option value="" selected disabled>-- Select an EA Code --</option>
              <optgroup label="Manufacturing Sectors">
                <option value="3">EA 3 – Food Products, Beverages, and Tobacco</option>
                <option value="4">EA 4 – Textiles and Textile Products</option>
                <option value="5">EA 5 – Leather and Leather Products</option>
                <option value="6">EA 6 – Wood and Wood Products</option>
                <option value="7">EA 7 – Pulp, Paper, and Paper Products</option>
                <option value="8">EA 8 – Publishing Companies</option>
                <option value="9">EA 9 – Printing Companies</option>
                <option value="10">EA 10 – Manufacture of Coke and Refined Petroleum Products</option>
                <option value="12">EA 12 – Chemicals, Chemical Products, and Fibers</option>
                <option value="13">EA 13 – Pharmaceuticals</option>
              </optgroup>
              <optgroup label="Service Sectors">
                <option value="28">EA 28 – Construction</option>
                <option value="29">EA 29 – Wholesale and Retail Trade</option>
                <option value="30">EA 30 – Hotels and Restaurants</option>
                <option value="31">EA 31 – Transport, Storage, and Communication</option>
                <option value="32">EA 32 – Financial Intermediation, Real Estate, Renting</option>
                <option value="33">EA 33 – Information Technology</option>
                <option value="34">EA 34 – Engineering Services</option>
                <option value="35">EA 35 – Other Services</option>
              </optgroup>
              <optgroup label="Other Industries">
                <option value="39">EA 39 – Other Social Services (Healthcare, Education)</option>
              </optgroup>
            </select>
          </div>
        </div>

        <!-- Customization Options (Moved to the bottom) -->
        <div class="mt-5">
          <h6 class="mb-3">Customization Options</h6>
          <form>
            <!-- Theme Selection -->
            <div class="mb-3">
              <label for="themeSelection" class="form-label">Select Theme</label>
              <select class="form-select" id="themeSelection">
                <option value="light">Light Theme</option>
                <option value="dark">Dark Theme</option>
                <option value="blue">Blue Theme</option>
                <option value="green">Green Theme</option>
              </select>
            </div>

            <!-- Notification Preferences -->
            <div class="mb-3">
              <label class="form-label">Notification Preferences</label>
              <div class="form-check">
                <input class="form-check-input" type="checkbox" id="emailNotifications" checked>
                <label class="form-check-label" for="emailNotifications">
                  Email Notifications
                </label>
              </div>
              <div class="form-check">
                <input class="form-check-input" type="checkbox" id="smsNotifications">
                <label class="form-check-label" for="smsNotifications">
                  SMS Notifications
                </label>
              </div>
            </div>

            <!-- Dashboard Layout -->
            <div class="mb-3">
              <label class="form-label">Dashboard Layout</label>
              <div class="form-check">
                <input class="form-check-input" type="radio" name="dashboardLayout" id="layoutDefault" checked>
                <label class="form-check-label" for="layoutDefault">
                  Default Layout
                </label>
              </div>
              <div class="form-check">
                <input class="form-check-input" type="radio" name="dashboardLayout" id="layoutCompact">
                <label class="form-check-label" for="layoutCompact">
                  Compact Layout
                </label>
              </div>
            </div>

            <!-- Save Changes Button -->
            <button type="submit" class="btn btn-primary">Save Changes</button>
          </form>
        </div>
      </div>
    </div>
  </div>

  <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer>
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center active">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors</div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Help</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>