<?php
session_start();
if (!isset($_SESSION['companyName'])) {
    $_SESSION['companyName'] = 'Acme, Inc.';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.5.0/font/bootstrap-icons.min.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Audit Master</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .nav-tabs .nav-link {
            border: 1px solid #ddd;
            color: #6c757d;
            padding: 10px 15px;
        }
        
        .nav-tabs .nav-link.active {
            background-color: #f8f9fa;
            color: #000;
            border: 1px solid #ddd;
        }
        
        .nav-tabs .nav-link:hover {
            background-color: #e9ecef;
            color: #000;
        }
        
        .delimited-section {
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #ffffff;
            margin-bottom: 20px;
        }
        
        .navbar-text {
            display: none;
        }
        
        @media (min-width: 992px) {
            .navbar-text {
                display: inline;
            }
        }
        
        .sticky-top {
            position: -webkit-sticky;
            position: sticky;
            top: 0;
            z-index: 1030;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        .form-check-input {
            width: 1.5em;
            height: 1.5em;
            margin-right: 10px;
        }
        
        .form-check-label {
            font-size: 1.2em;
            margin-left: 5px;
        }
        
        footer {
            position: absolute;
            bottom: 0;
            width: 100%;
            height: 60px;
            background-color: #f8f9fa;
        }
    </style>
</head>
<body>
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-light bg-light sticky-top">
        <div class="container">
            <a class="navbar-brand" href="#">My ISO Pro</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Link</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Link</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Link</a>
                    </li>
                </ul>
                <span class="navbar-text mx-auto fw-bold" style="font-size: 1.5rem;">Audit Master</span>
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="support.php"><i class="bi bi-question-circle"></i> Help</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="profile.php"><i class="bi bi-person-circle"></i> Profile</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="alertsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-bell"></i> Alerts
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="alertsDropdown">
                            <li><a class="dropdown-item" href="#">Messages</a></li>
                            <li><a class="dropdown-item" href="#">To-Do Items</a></li>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <h1 class="text-center mt-5"><?php echo $_SESSION['companyName']; ?></h1>

    <!-- Tabs Section -->
    <div class="container mt-3">
        <ul class="nav nav-tabs" id="myTab" role="tablist" style="overflow-x: auto; white-space: nowrap; flex-wrap: nowrap;">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="true">Profile</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="plan-scope-tab" data-bs-toggle="tab" data-bs-target="#plan-scope" type="button" role="tab" aria-controls="plan-scope" aria-selected="false">Plan/Scope</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="notes-evidence-tab" data-bs-toggle="tab" data-bs-target="#notes-evidence" type="button" role="tab" aria-controls="notes-evidence" aria-selected="false">Notes/Evidence</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="report-formatting-tab" data-bs-toggle="tab" data-bs-target="#report-formatting" type="button" role="tab" aria-controls="report-formatting" aria-selected="false">Report Formatting</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="findings-tab" data-bs-toggle="tab" data-bs-target="#findings" type="button" role="tab" aria-controls="findings" aria-selected="false">Findings</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="corrective-action-tab" data-bs-toggle="tab" data-bs-target="#corrective-action" type="button" role="tab" aria-controls="corrective-action" aria-selected="false">Corrective Action</button>
            </li>
        </ul>
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                <h2 class="text-center mt-4">Profile Info</h2>
                <form method="post" action="profile_process.php">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="companyName" class="form-label"><strong>Company Name</strong></label>
                                <input type="text" class="form-control" id="companyName" name="company_name" value="<?php echo isset($_SESSION['companyName']) ? htmlspecialchars($_SESSION['companyName'], ENT_QUOTES) : ''; ?>">
                            </div>
                            <div class="mb-3">
                                <label for="auditorId" class="form-label"><strong>Auditor ID</strong></label>
                                <input type="text" class="form-control" id="auditorId" name="auditor_id">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="address" class="form-label"><strong>Address</strong></label>
                                <input type="text" class="form-control" id="address" name="address">
                            </div>
                            <div class="mb-3">
                                <label for="cityStateZip" class="form-label"><strong>City, State, ZIP</strong></label>
                                <div class="d-flex">
                                    <input type="text" class="form-control me-2" id="city" name="city" placeholder="City">
                                    <input type="text" class="form-control me-2" id="state" name="state" placeholder="State">
                                    <input type="text" class="form-control" id="zip" name="zip" placeholder="ZIP">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Site Type</strong></label><br>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="singleSite" name="site_type" value="single">
                                    <label class="form-check-label" for="singleSite" style="font-size: 1.2em;">Single Site</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="multipleSites" name="site_type" value="multiple">
                                    <label class="form-check-label" for="multipleSites" style="font-size: 1.2em;">Multiple Sites</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Audit Type</strong></label><br>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="internalAudit" name="audit_type" value="internal">
                                    <label class="form-check-label" for="internalAudit" style="font-size: 1.2em;">Internal</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="supplyChainAudit" name="audit_type" value="supplyChain">
                                    <label class="form-check-label" for="supplyChainAudit" style="font-size: 1.2em;">Supply Chain</label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Standards</strong></label><br>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso9001" name="standards[]" value="ISO9001 Quality">
                                    <label class="form-check-label" for="iso9001" style="font-size: 1.2em;">ISO9001 Quality</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso45001" name="standards[]" value="ISO 45001 Safety">
                                    <label class="form-check-label" for="iso45001" style="font-size: 1.2em;">ISO 45001 Safety</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso14001" name="standards[]" value="ISO14001 Environmental">
                                    <label class="form-check-label" for="iso14001" style="font-size: 1.2em;">ISO14001 Environmental</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="customStandard" name="standards[]" value="Custom">
                                    <label class="form-check-label" for="customStandard" style="font-size: 1.2em;">Custom</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-light w-100 mt-3">Submit</button>
                </form>
            </div>
            <div class="tab-pane fade" id="plan-scope" role="tabpanel" aria-labelledby="plan-scope-tab">
                <h2 class="text-center mt-4">Plan/Scope Section</h2>
                <p>Content for Plan/Scope goes here...</p>
            </div>
            <div class="tab-pane fade" id="notes-evidence" role="tabpanel" aria-labelledby="notes-evidence-tab">
                <h2 class="text-center mt-4">Notes/Evidence Section</h2>
                <p>Content for Notes/Evidence goes here...</p>
            </div>
            <div class="tab-pane fade" id="report-formatting" role="tabpanel" aria-labelledby="report-formatting-tab">
                <h2 class="text-center mt-4">Report Formatting Section</h2>
                <p>Content for Report Formatting goes here...</p>
            </div>
            <div class="tab-pane fade" id="findings" role="tabpanel" aria-labelledby="findings-tab">
                <h2 class="text-center mt-4">Findings Section</h2>
                <p>Content for Findings goes here...</p>
            </div>
            <div class="tab-pane fade" id="corrective-action" role="tabpanel" aria-labelledby="corrective-action-tab">
                <h2 class="text-center mt-4">Corrective Action Section</h2>
                <p>Content for Corrective Action goes here...</p>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS (Optional for interactive components) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Footer Section -->
    <footer class="bg-light text-center text-lg-start mt-5">
        <div class="container p-4">
            <p class="text-center">&copy; <?=date('Y')?> Audit Master. All rights reserved.</p>
        </div>
    </footer>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const footer = document.querySelector("footer");
            function adjustFooter() {
                if (document.body.scrollHeight <= window.innerHeight) {
                    footer.style.position = "fixed";
                } else {
                    footer.style.position = "static";
                }
            }
            window.addEventListener("resize", adjustFooter);
            adjustFooter();
        });
    </script>
</body>
</html>

