<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Page Title - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Only essential styles remain */
    .content-wrapper {
      padding: 20px;
    }
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    footer a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: black;
      text-decoration: none;
    }
    footer .footer-section {
      border-right: 1px solid #ddd;
    }
    footer .footer-section:last-child {
      border-right: none;
    }
  </style>
</head>
<body>

  <!-- Navigation Bar -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <!-- Left Column: Home, Audits, Reports -->
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audits.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
          <a class="btn btn-outline-secondary" href="reports.php">
            <i class="fa-solid fa-file-lines"></i>
          </a>
        </div>
        <!-- Center Column: Enlarged Company Name -->
        <div class="col-4 text-center">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <!-- Right Column: Profile, Support, Logout -->
        <div class="col-4 d-flex justify-content-end">
          <a class="btn btn-outline-secondary me-2" href="profile.php">
            <i class="fa-solid fa-user"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="support.php">
            <i class="fa-solid fa-circle-question"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Main Content -->
  <div class="container-fluid my-4">
    <!-- Page-specific content goes here -->
    <div class="content-wrapper">
      <!-- Add your page-specific content here -->

  <style>
    .section-header {
      margin-top: 2rem;
    }
    .card pre {
      background-color: #f8f9fa;
      padding: 1rem;
    }
  </style>
<div class="form-container">
    <h2>Add Auditor</h2>
    <form action="save_auditor.php" method="POST">
      <!-- Auditor Name -->
      <div class="mb-3">
        <label for="auditorName" class="form-label">Auditor Name</label>
        <input type="text" class="form-control" id="auditorName" name="auditorName" required>
      </div>

      <!-- Email -->
      <div class="mb-3">
        <label for="auditorEmail" class="form-label">Email</label>
        <input type="email" class="form-control" id="auditorEmail" name="auditorEmail" required>
      </div>

      <!-- Phone -->
      <div class="mb-3">
        <label for="auditorPhone" class="form-label">Phone</label>
        <input type="tel" class="form-control" id="auditorPhone" name="auditorPhone" required>
      </div>

      <!-- Experience Level -->
      <div class="mb-3">
        <label for="experienceLevel" class="form-label">Experience Level</label>
        <select class="form-select" id="experienceLevel" name="experienceLevel" required>
          <option value="" disabled selected>Select Experience Level</option>
          <option value="Junior">Junior</option>
          <option value="Senior">Senior</option>
          <option value="Lead">Lead</option>
        </select>
      </div>

      <!-- Competencies -->
      <div class="mb-3">
        <label for="competencies" class="form-label">Competencies</label>
        <div class="form-check">
          <input class="form-check-input" type="checkbox" id="iso9001" name="competencies[]" value="ISO 9001">
          <label class="form-check-label" for="iso9001">ISO 9001</label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="checkbox" id="iso14001" name="competencies[]" value="ISO 14001">
          <label class="form-check-label" for="iso14001">ISO 14001</label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="checkbox" id="itAudits" name="competencies[]" value="IT Audits">
          <label class="form-check-label" for="itAudits">IT Audits</label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="checkbox" id="other" name="competencies[]" value="Other">
          <label class="form-check-label" for="other">Other</label>
        </div>
      </div>

      <!-- Notes -->
      <div class="mb-3">
        <label for="auditorNotes" class="form-label">Notes</label>
        <textarea class="form-control" id="auditorNotes" name="auditorNotes" rows="3"></textarea>
      </div>

      <!-- Submit Button -->
      <button type="submit" class="btn btn-primary">Save Auditor</button>
    </form>
  </div>
 

  <!-- Sticky Footer -->
  <footer class="bg-light fixed-bottom border-top">
    <div class="container">
      <div class="row">
        <div class="col footer-section text-center">
          <a href="#"><i class="fa-solid fa-home fa-lg"></i></a>
        </div>
        <div class="col footer-section text-center">
          <a href="#"><i class="fa-solid fa-search fa-lg"></i></a>
        </div>
        <div class="col footer-section text-center">
          <a href="#"><i class="fa-solid fa-bell fa-lg"></i></a>
        </div>
        <div class="col text-center">
          <a href="#"><i class="fa-solid fa-user fa-lg"></i></a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
