<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Audit Report Summary - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Ensure the body takes up the full height of the viewport */
    html, body {
      height: 100%;
      margin: 0;
    }
    /* Content wrapper with padding to prevent overlap with the footer */
    .content-wrapper {
      padding: 20px;
      padding-bottom: 80px; /* Add padding to prevent footer overlap */
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
      border-top: 1px solid #dee2e6; /* Add a border to the top of the footer */
      position: fixed; /* Make the footer sticky */
      bottom: 0; /* Stick it to the bottom */
      left: 0;
      right: 0;
      z-index: 1000; /* Ensure the footer stays above other content */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.01);
    }
    /* Active state for the footer section */
    footer .footer-section.active {
      border-top: 4px solid #ffffff; /* White border to indicate active state */
      box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1); /* Subtle shadow for emphasis */
    }
    /* Report summary styling */
    .report-summary {
      margin-top: 20px;
    }
    .report-summary .card {
      margin-bottom: 20px;
      border: none;
      border-radius: 10px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    .report-summary .card-header {
      background-color: #ffffff;
      font-weight: bold;
      font-size: 20px;
      color: #343a40;
      border-bottom: none;
    }
    .report-summary .card-body {
      padding: 20px;
    }
    .report-summary .card-body h5 {
      margin-bottom: 15px;
      color: #343a40;
    }
    .report-summary .card-body ul {
      padding-left: 20px;
    }
    .report-summary .card-body ul li {
      margin-bottom: 10px;
      color: #495057;
    }
    .report-summary .card-body p {
      margin-bottom: 10px;
      color: #495057;
    }
    /* Subtle card backgrounds */
    .card.overview {
      background: linear-gradient(135deg, #e3f2fd, #bbdefb);
    }
    .card.metrics {
      background: linear-gradient(135deg, #fce4ec, #f8bbd0);
    }
    .card.findings {
      background: linear-gradient(135deg, #e1f5fe, #b3e5fc);
    }
    .card.recommendations {
      background: linear-gradient(135deg, #e8f5e9, #c8e6c9);
    }
    /* Key metrics styling */
    .key-metric {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 10px;
      background-color: rgba(255, 255, 255, 0.5);
      border-radius: 8px;
      margin-bottom: 10px;
    }
    .key-metric .label {
      font-weight: bold;
      color: #343a40;
    }
    .key-metric .value {
      font-size: 18px;
      font-weight: bold;
      color: #343a40;
    }
  </style>
</head>
<body>
  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          <a class="btn btn-outline-secondary me-2" href="alerts.php">
            <i class="fa-solid fa-bell"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Audit Report Summary Content -->
  <div class="content-wrapper">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <h1 class="text-center mt-3"><?php echo $_SESSION['companyName']; ?></h1>
          <h2 class="mb-4">Audit Report Summary</h2>
          <div class="report-summary">
            <!-- Audit Overview Card -->
            <div class="card overview">
              <div class="card-header">Audit Overview</div>
              <div class="card-body">
                <h5>ISO 9001 Compliance Audit</h5>
                <p><strong>Date:</strong> 2023-10-15</p>
                <p><strong>Auditor:</strong> John Doe</p>
                <p><strong>Status:</strong> Completed</p>
              </div>
            </div>

            <!-- Key Metrics Card -->
            <div class="card metrics">
              <div class="card-header">Key Metrics</div>
              <div class="card-body">
                <div class="key-metric">
                  <span class="label">Total Questions</span>
                  <span class="value">50</span>
                </div>
                <div class="key-metric">
                  <span class="label">Passed</span>
                  <span class="value">45 (90%)</span>
                </div>
                <div class="key-metric">
                  <span class="label">Failed</span>
                  <span class="value">5 (10%)</span>
                </div>
                <div class="key-metric">
                  <span class="label">Non-Conformities</span>
                  <span class="value">3</span>
                </div>
              </div>
            </div>

            <!-- Clause 4: Context of the Organization -->
            <div class="card findings">
              <div class="card-header">Clause 4: Context of the Organization</div>
              <div class="card-body">
                <h5>Understanding internal and external factors affecting quality management.</h5>
                <ul>
                  <li><strong>4.1:</strong> The organization has determined internal and external issues affecting its QMS.</li>
                  <li><strong>4.2:</strong> The needs and expectations of interested parties are identified.</li>
                  <li><strong>4.3:</strong> The scope of the QMS is documented and maintained.</li>
                  <li><strong>4.4:</strong> QMS processes are defined, documented, and implemented.</li>
                </ul>
                <h5>Recommendations:</h5>
                <ul>
                  <li>Regularly review and update the context of the organization to reflect changes in internal and external issues.</li>
                </ul>
              </div>
            </div>

            <!-- Clause 5: Leadership -->
            <div class="card findings">
              <div class="card-header">Clause 5: Leadership</div>
              <div class="card-body">
                <h5>Top management commitment to the QMS.</h5>
                <ul>
                  <li><strong>5.1:</strong> Top management demonstrates leadership and commitment to the QMS.</li>
                  <li><strong>5.2:</strong> A quality policy is established, communicated, and understood.</li>
                  <li><strong>5.3:</strong> Responsibilities and authorities for the QMS are assigned and communicated.</li>
                </ul>
                <h5>Recommendations:</h5>
                <ul>
                  <li>Conduct regular leadership reviews to ensure continued commitment to the QMS.</li>
                </ul>
              </div>
            </div>

            <!-- Clause 6: Planning -->
            <div class="card findings">
              <div class="card-header">Clause 6: Planning</div>
              <div class="card-body">
                <h5>Identifying and addressing risks and opportunities.</h5>
                <ul>
                  <li><strong>6.1:</strong> Risks and opportunities are identified and addressed.</li>
                  <li><strong>6.2:</strong> Quality objectives are established and measurable.</li>
                  <li><strong>6.3:</strong> There is a process for planning changes to the QMS.</li>
                </ul>
                <h5>Recommendations:</h5>
                <ul>
                  <li>Enhance the risk management process to include more proactive identification of risks and opportunities.</li>
                </ul>
              </div>
            </div>

            <!-- Clause 7: Support -->
            <div class="card findings">
              <div class="card-header">Clause 7: Support</div>
              <div class="card-body">
                <h5>Providing adequate resources for the QMS.</h5>
                <ul>
                  <li><strong>7.1:</strong> Adequate resources are provided for the QMS.</li>
                  <li><strong>7.2:</strong> Employees are competent and trained for their roles.</li>
                  <li><strong>7.3:</strong> Documented information is properly controlled (created, updated, stored).</li>
                </ul>
                <h5>Recommendations:</h5>
                <ul>
                  <li>Implement a more robust training program to ensure all employees are fully competent in their roles.</li>
                </ul>
              </div>
            </div>

            <!-- Clause 8: Operation -->
            <div class="card findings">
              <div class="card-header">Clause 8: Operation</div>
              <div class="card-body">
                <h5>Ensuring operational control to meet requirements.</h5>
                <ul>
                  <li><strong>8.1:</strong> Operational controls are in place to meet customer and regulatory requirements.</li>
                  <li><strong>8.2:</strong> Customer communication and contract review processes are effective.</li>
                  <li><strong>8.3:</strong> External providers and suppliers are evaluated for compliance.</li>
                  <li><strong>8.4:</strong> Controls are in place to prevent nonconforming product or service delivery.</li>
                </ul>
                <h5>Recommendations:</h5>
                <ul>
                  <li>Strengthen supplier evaluation processes to ensure consistent compliance.</li>
                </ul>
              </div>
            </div>

            <!-- Clause 9: Performance Evaluation -->
            <div class="card findings">
              <div class="card-header">Clause 9: Performance Evaluation</div>
              <div class="card-body">
                <h5>Monitoring and measuring QMS effectiveness.</h5>
                <ul>
                  <li><strong>9.1:</strong> There is a process for monitoring and measuring QMS effectiveness.</li>
                  <li><strong>9.2:</strong> Customer satisfaction levels are monitored.</li>
                  <li><strong>9.3:</strong> Internal audits are conducted at planned intervals.</li>
                </ul>
                <h5>Recommendations:</h5>
                <ul>
                  <li>Enhance customer satisfaction monitoring to include more detailed feedback mechanisms.</li>
                </ul>
              </div>
            </div>

            <!-- Clause 10: Improvement -->
            <div class="card findings">
              <div class="card-header">Clause 10: Improvement</div>
              <div class="card-body">
                <h5>Identifying nonconformities and taking corrective action.</h5>
                <ul>
                  <li><strong>10.1:</strong> Nonconformities are identified and corrective actions are taken.</li>
                  <li><strong>10.2:</strong> There is a process for continual improvement of the QMS.</li>
                </ul>
                <h5>Recommendations:</h5>
                <ul>
                  <li>Implement a more proactive approach to identifying and addressing nonconformities.</li>
                </ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer>
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors</div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Help</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center active">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>