<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>ISO 9001 Audit Checklist - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Ensure the body takes up the full height of the viewport */
    html, body {
      height: 100%;
      margin: 0;
    }
    /* Content wrapper with padding to prevent overlap with the footer */
    .content-wrapper {
      padding: 20px;
      padding-bottom: 80px; /* Add padding to prevent footer overlap */
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
      /*height: 100px;  Fixed height for the footer */
      border-top: 1px solid #dee2e6; /* Add a border to the top of the footer */
      position: fixed; /* Make the footer sticky */
      bottom: 0; /* Stick it to the bottom */
      left: 0;
      right: 0;
      z-index: 1000; /* Ensure the footer stays above other content */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.05);
    }
    /* Active state for the footer section */
    footer .footer-section.active {
      border-top: 4px solid #ffffff; /* White border to indicate active state */
      box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1); /* Subtle shadow for emphasis */
    }
    /* Checklist styling */
    .clause-section {
      padding: 20px;
      margin-top: 20px;
      border-radius: 5px;
    }
    .clause-4 { background-color: #e3f2fd; border-left: 6px solid #2196f3; }
    .clause-5 { background-color: #f3e5f5; border-left: 6px solid #9c27b0; }
    .clause-6 { background-color: #fce4ec; border-left: 6px solid #e91e63; }
    .clause-7 { background-color: #e8f5e9; border-left: 6px solid #4caf50; }
    .clause-8 { background-color: #fff3e0; border-left: 6px solid #ff9800; }
    .clause-9 { background-color: #ede7f6; border-left: 6px solid #673ab7; }
    .clause-10 { background-color: #ffebee; border-left: 6px solid #f44336; }
    .add-question-btn {
      margin-top: 10px;
    }
    .custom-question {
      display: flex;
      align-items: center;
      gap: 10px;
      margin-top: 10px;
    }
    /* Adjust spacing for the checklist title */
    h2.mb-4 {
      margin-top: 20px; /* Reduced space above the title */
      margin-bottom: 20px !important; /* Consistent spacing below the title */
    }
  </style>
</head>
<body>
  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          <a class="btn btn-outline-secondary me-2" href="alerts.php">
            <i class="fa-solid fa-bell"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- ISO 9001 Audit Checklist Content -->
  <div class="content-wrapper">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <h1 class="text-center mt-3"><?php echo $_SESSION['companyName']; ?></h1>
          <h2 class="mb-4">Step 1: ISO 9001 Create Your Audit Checklist</h2>
          <p>Check/Uncheck questions you want to use. You can also create new questions for each section:</p>
          <form action="#" method="post" id="auditForm">
            <div id="checklistContainer"></div>
            <button type="submit" class="btn btn-dark mt-4 mb-4 w-100" style="border:1px solid lightgray;">Create Audit</button>
          </form>
        </div>
      </div>
    </div>
  </div>

    <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer>
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors</div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Help</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    const checklistData = {
      "4": { title: "Context of the Organization", blurb: "Understanding internal and external factors affecting quality management.", questions: [
        { clause: "4.1", question: "Has the organization determined internal and external issues affecting its QMS?" },
        { clause: "4.2", question: "Are the needs and expectations of interested parties identified?" },
        { clause: "4.3", question: "Is the scope of the QMS documented and maintained?" },
        { clause: "4.4", question: "Are QMS processes defined, documented, and implemented?" }
      ]},
      "5": { title: "Leadership", blurb: "Top management commitment to the QMS.", questions: [
        { clause: "5.1", question: "Does top management demonstrate leadership and commitment to the QMS?" },
        { clause: "5.2", question: "Is a quality policy established, communicated, and understood?" },
        { clause: "5.3", question: "Are responsibilities and authorities for the QMS assigned and communicated?" }
      ]},
      "6": { title: "Planning", blurb: "Identifying and addressing risks and opportunities.", questions: [
        { clause: "6.1", question: "Are risks and opportunities identified and addressed?" },
        { clause: "6.2", question: "Are quality objectives established and measurable?" },
        { clause: "6.3", question: "Is there a process for planning changes to the QMS?" }
      ]},
      "7": { title: "Support", blurb: "Providing adequate resources for the QMS.", questions: [
        { clause: "7.1", question: "Are adequate resources provided for the QMS?" },
        { clause: "7.2", question: "Are employees competent and trained for their roles?" },
        { clause: "7.3", question: "Is documented information properly controlled (created, updated, stored)?" }
      ]},
      "8": { title: "Operation", blurb: "Ensuring operational control to meet requirements.", questions: [
        { clause: "8.1", question: "Are operational controls in place to meet customer and regulatory requirements?" },
        { clause: "8.2", question: "Are customer communication and contract review processes effective?" },
        { clause: "8.3", question: "Are external providers and suppliers evaluated for compliance?" },
        { clause: "8.4", question: "Are controls in place to prevent nonconforming product or service delivery?" }
      ]},
      "9": { title: "Performance Evaluation", blurb: "Monitoring and measuring QMS effectiveness.", questions: [
        { clause: "9.1", question: "Is there a process for monitoring and measuring QMS effectiveness?" },
        { clause: "9.2", question: "Are customer satisfaction levels monitored?" },
        { clause: "9.3", question: "Are internal audits conducted at planned intervals?" }
      ]},
      "10": { title: "Improvement", blurb: "Identifying nonconformities and taking corrective action.", questions: [
        { clause: "10.1", question: "Are nonconformities identified and corrective actions taken?" },
        { clause: "10.2", question: "Is there a process for continual improvement of the QMS?" }
      ]}
    };

    function renderChecklist() {
      const checklistContainer = document.getElementById("checklistContainer");
      checklistContainer.innerHTML = "";

      Object.keys(checklistData).forEach(clauseNumber => {
        const section = checklistData[clauseNumber];
        const sectionDiv = document.createElement("div");
        sectionDiv.classList.add("clause-section", `clause-${clauseNumber}`);
        sectionDiv.innerHTML = `<h4>Clause ${clauseNumber}: ${section.title}</h4><p>${section.blurb}</p>`;

        section.questions.forEach(item => {
          const div = document.createElement("div");
          div.classList.add("form-check");
          div.innerHTML = `<input class="form-check-input" type="checkbox" name="questions[]" value="${item.question}" checked>
              <label class="form-check-label">(${item.clause}) ${item.question}</label>`;
          sectionDiv.appendChild(div);
        });

        const addQuestionBtn = document.createElement("button");
        addQuestionBtn.classList.add("btn", "btn-sm", "btn-link", "add-question-btn");
        addQuestionBtn.innerText = "Add Custom Question";
        addQuestionBtn.addEventListener("click", (e) => {
          e.preventDefault();
          addCustomQuestion(sectionDiv, clauseNumber);
        });
        sectionDiv.appendChild(addQuestionBtn);

        checklistContainer.appendChild(sectionDiv);
      });
    }

    function addCustomQuestion(sectionDiv, clauseNumber) {
      const inputDiv = document.createElement("div");
      inputDiv.classList.add("custom-question");

      const input = document.createElement("input");
      input.type = "text";
      input.classList.add("form-control");
      input.placeholder = `Enter custom question for Clause ${clauseNumber}`;

      const removeButton = document.createElement("button");
      removeButton.classList.add("btn", "btn-danger", "btn-sm");
      removeButton.innerText = "x";
      removeButton.addEventListener("click", () => inputDiv.remove());

      inputDiv.appendChild(input);
      inputDiv.appendChild(removeButton);
      sectionDiv.appendChild(inputDiv);
    }

    renderChecklist();
  </script>
</body>
</html>