<?php
session_start();

ob_start(); // Start output buffering to avoid header issues
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database connection
$servername = "localhost";
$username = "iso";
$password = "2VFz1jilzOWXMupl";
$dbname = "iso";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set company ID (static for now)
$company_id = $_SESSION['user_id'];

// Check if the form has been submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    $company_name = $conn->real_escape_string($_POST['company_name']);
    $auditor_id = $conn->real_escape_string($_POST['auditor_id']);
    $site_type = $conn->real_escape_string($_POST['site_type']);
    $audit_type = $conn->real_escape_string($_POST['audit_type']);
    $standards = isset($_POST['standards']) ? implode(", ", $_POST['standards']) : "";

    // Validate and truncate standards if necessary
    $max_length = 65535; // Maximum for TEXT type
    if (strlen($standards) > $max_length) {
        $standards = substr($standards, 0, $max_length);
    }

    // Check submission count for the company ID
    $sql_check = "SELECT COUNT(*) AS submission_count FROM audit_profile_info WHERE company_id = ?";
    $stmt_check = $conn->prepare($sql_check);

    if (!$stmt_check) {
        die("Prepare failed for submission count check: " . $conn->error);
    }

    $stmt_check->bind_param("s", $company_id);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();
    $row = $result_check->fetch_assoc();

    if ($row['submission_count'] >= 3) {
        echo "<p style='color: red; text-align: center;'>Submission limit reached. You cannot submit the form more than 3 times.</p>";
        echo '<div class="text-center mt-4">';
        echo '<a href="dashboard.php" class="btn btn-primary">Back to Dashboard</a>';
        echo '</div>';
    } else {
        // Insert data into the database
        $sql_insert = "INSERT INTO audit_profile_info (company_id, company_name, auditor_id, site_type, audit_type, standards, created_at) 
                       VALUES (?, ?, ?, ?, ?, ?, NOW())";

        $stmt_insert = $conn->prepare($sql_insert);

        if (!$stmt_insert) {
            die("Prepare failed for data insertion: " . $conn->error);
        }

        $stmt_insert->bind_param("ssssss", $company_id, $company_name, $auditor_id, $site_type, $audit_type, $standards);

        if ($stmt_insert->execute()) {
            // Redirect to dashboard on success
            header("Location: dashboard.php");
            exit;
        } else {
            die("<p style='color: red; text-align: center;'>Insert failed: " . $stmt_insert->error . "</p>");
        }
    }

    $stmt_check->close();
    if (isset($stmt_insert) && $stmt_insert) {
        $stmt_insert->close();
    }
}

$conn->close();
?>
