<?php 

$title = "Admin Dashboard";
$slug="dashboard-admin";

include 'inc.header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block bg-light sidebar">
            <div class="position-sticky">
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link active" aria-current="page" href="dashboard-admin.php">
                            <?=$title?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            Link
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            Reports
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">
                            Settings
                        </a>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Main content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">

            <?php
            // Include database connection
            include 'inc.db.php';

            // Establish the database connection
            $conn = db_connect();

            // Handle search query
            $search = isset($_GET['search']) ? $_GET['search'] : '';

            // SQL query to fetch companies and their audits
            $sql = "SELECT myisopro_users.company_name AS main_company_name, audit_profile_info.company_name AS audit_company_name, audit_profile_info.audit_type, audit_profile_info.site_type, audit_profile_info.standards, audit_profile_info.id AS audit_id 
                    FROM myisopro_users 
                    LEFT JOIN audit_profile_info 
                    ON myisopro_users.id = audit_profile_info.company_id";

            if (!empty($search)) {
                $sql .= " WHERE myisopro_users.company_name LIKE ?";
            }
            $sql .= " ORDER BY myisopro_users.company_name"; // Ensure ORDER BY comes after WHERE

            $stmt = $conn->prepare($sql);

            if (!empty($search)) {
                $searchParam = "%" . $search . "%";
                $stmt->bind_param("s", $searchParam);
            }

            $stmt->execute();
            $result = $stmt->get_result();
            ?>

            <div class="container mt-5">
                <h2 class="mb-4">Company Audits</h2>
                <form method="GET" class="mb-3">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control" placeholder="Search by company name" value="<?php echo htmlspecialchars($search); ?>">
                        <button type="submit" class="btn btn-primary">Search</button>
                    </div>
                </form>
                <table class="table table-bordered">
                    <thead class="table-dark">
                        <tr>
                            <th>Company Name</th>
                            <th>Audit Company Name</th>
                            <th>Audit Type</th>
                            <th>Site Type</th>
                            <th>Standards</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if ($result->num_rows > 0) {
                            $currentCompany = null;

                            while ($row = $result->fetch_assoc()) {
                                if ($row['main_company_name'] !== $currentCompany) {
                                    // New company header
                                    $currentCompany = $row['main_company_name'];
                                    echo "<tr class='table-primary'><td colspan='6'><strong>" . htmlspecialchars($currentCompany) . "</strong></td></tr>";
                                }
                                if ($row['audit_id'] !== null) {
                                    // Audit rows
                                    echo "<tr>";
                                    echo "<td></td>"; // Empty cell for alignment
                                    echo "<td>" . htmlspecialchars($row['audit_company_name']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['audit_type']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['site_type']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['standards']) . "</td>";
                                    echo "<td><button class='btn btn-success' data-bs-toggle='modal' data-bs-target='#requestAccessModal' data-audit-id='" . $row['audit_id'] . "'>Request Access</button></td>";
                                    echo "</tr>";
                                } else {
                                    // No audits available
                                    echo "<tr>";
                                    echo "<td></td>"; // Empty cell for alignment
                                    echo "<td></td>"; // Empty cell for alignment
                                    echo "<td></td>"; // Empty cell for alignment
                                    echo "<td></td>"; // Empty cell for alignment
                                    echo "<td class='text-center text-muted'>No audits available</td>";
                                    echo "<td></td>"; // Empty cell for alignment
                                    echo "</tr>";
                                }
                            }
                        } else {
                            echo "<tr><td colspan='6' class='text-center'>No audits found</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="requestAccessModal" tabindex="-1" aria-labelledby="requestAccessModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="requestAccessModalLabel">Request Access</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            Are you sure you want to request access for this audit?
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Confirm</button>
                        </div>
                    </div>
                </div>
            </div>

            <?php
            // Close connection
            $conn->close();
            ?>
        </main>
    </div>
</div>

<?php include 'inc.footer.php'; ?>
