<?php 
include 'inc.header.php'; // Ensure session starts
include 'inc.db.php'; // Database connection

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (!isset($_SESSION['user_id'])) {
    die("User not logged in");
}

$user_id = $_SESSION['user_id'];
$conn = db_connect();

// Fetch progress_scope only if not already set in session
if (!isset($_SESSION['progress_scope'])) {
    $stmt = $conn->prepare("SELECT progress_scope FROM user_progress WHERE user_id = ?");
    if ($stmt) {
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        $_SESSION['progress_scope'] = $row ? $row['progress_scope'] : 0;
        $stmt->close();
    } else {
        die("SQL Error: " . $conn->error);
    }
}

// Handle progress updates
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['progress_scope'])) {
    $progress = intval($_POST['progress_scope']);
    
    // Ensure progress_scope is updated only forward
    if ($progress > $_SESSION['progress_scope']) {
        $_SESSION['progress_scope'] = $progress;
        
        $stmt = $conn->prepare("INSERT INTO user_progress (user_id, progress_scope) 
                                VALUES (?, ?) 
                                ON DUPLICATE KEY UPDATE progress_scope = VALUES(progress_scope)");
        if ($stmt) {
            $stmt->bind_param("ii", $user_id, $_SESSION['progress_scope']);
            $stmt->execute();
            $stmt->close();
        } else {
            die("SQL Error: " . $conn->error);
        }
    }
    echo $_SESSION['progress_scope'];
    exit;
}

$title = "Program Management";
$slug = "program-management";
?>

<div class="container mt-5">
    <h1 class="text-center">Customize IsoPro</h1>
    <p class="text-center fw-bold">Program Setup Progress</p>
    
    <div class="d-flex justify-content-between">
        <span>0%</span>
        <span>100%</span>
    </div>
    <div class="progress mb-4" style="height: 30px;">
        <div class="progress-bar" role="progressbar" id="progressBar" style="width: <?=$_SESSION['progress_scope']?>%; font-size: 1rem;" 
             aria-valuenow="<?=$_SESSION['progress_scope']?>" aria-valuemin="0" aria-valuemax="100">
          <?=$_SESSION['progress_scope']?>%
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <ul class="nav nav-tabs" id="setupTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="step1-tab" data-bs-toggle="tab" data-bs-target="#step1" type="button" role="tab">Step 1: Scope</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="step2-tab" data-bs-toggle="tab" data-bs-target="#step2" type="button" role="tab">Step 2: Auditor Competencies</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="step3-tab" data-bs-toggle="tab" data-bs-target="#step3" type="button" role="tab">Step 3: Report Settings</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="step4-tab" data-bs-toggle="tab" data-bs-target="#step4" type="button" role="tab">Step 4: Terms</button>
                </li>
            </ul>
            
            <div class="tab-content mt-3" id="setupTabsContent">
                <div class="tab-pane fade show active" id="step1" role="tabpanel">
                    <h3>General Scope</h3>

<div class="container mt-5">

    <form method="post" action="process_profile.php">
        <!-- Profile Information Row -->
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="companyName" class="form-label"><strong>Company Name</strong></label>
                    <input type="text" class="form-control" id="companyName" name="company_name" value="<?= htmlspecialchars($_SESSION['company_name']); ?>">
                </div>
                <div class="mb-3">
                    <label for="programManager" class="form-label"><strong>Program Manager</strong></label>
                    <input type="text" class="form-control" id="programManager" name="programManager" value="">
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="address" class="form-label"><strong>Address</strong></label>
                    <input type="text" class="form-control" id="address" name="address" value="<?= htmlspecialchars($_SESSION['address']); ?>">
                </div>
                <div class="mb-3">
                    <label for="cityStateZip" class="form-label"><strong>City, State, ZIP, Country</strong></label>
                    <div class="d-flex">
                        <input type="text" class="form-control me-2" id="city" name="city" placeholder="City" value="<?= htmlspecialchars($_SESSION['city']); ?>">
                        <input type="text" class="form-control me-2" id="state" name="state" placeholder="State" value="<?= htmlspecialchars($_SESSION['state']); ?>">
                        <input type="text" class="form-control me-2" id="zip" name="zip" placeholder="ZIP" value="<?= htmlspecialchars($_SESSION['zip']); ?>">
                        <input type="text" class="form-control" id="country" name="country" placeholder="Country" value="<?= htmlspecialchars($_SESSION['country']); ?>">
                    </div>
                </div>
            </div>
        </div>

        <!-- Selection Rows -->
        <div class="row mt-4">
            <!-- Site Type -->
            <div class="col-md-4 border p-3 rounded">
                <label class="form-label"><strong>Site Type</strong></label><br>
                <div class="form-check">
                    <input class="form-check-input" type="radio" id="singleSite" name="site_type" value="single" checked>
                    <label class="form-check-label" for="singleSite">Single Site</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" id="multipleSites" name="site_type" value="multiple" disabled>
                    <label class="form-check-label text-muted" for="multipleSites">Multiple Sites (coming soon)</label>
                </div>
            </div>

            <!-- Audit Type -->
            <div class="col-md-4 border p-3 rounded">
                <label class="form-label"><strong>Audit Type</strong></label><br>
                <div class="form-check">
                    <input class="form-check-input" type="radio" id="internalAudit" name="audit_type" value="internal" checked>
                    <label class="form-check-label" for="internalAudit">ISO Internal Audit</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" id="supplyChainAudit" name="audit_type" value="supplyChain" disabled>
                    <label class="form-check-label text-muted" for="supplyChainAudit" >Supply Chain</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="radio" id="RegulatoryComplianceEvaluation" name="audit_type" value="RegulatoryComplianceEvaluation" disabled style="opacity: 1; pointer-events: none;">
                    <label class="form-check-label" for="RegulatoryComplianceEvaluation" >Regulatory Compliance Evaluation</label>
                </div>
            </div>

            <!-- Standards -->
            <div class="col-md-4 border p-3 rounded">
                <label class="form-label"><strong>Standards</strong></label><br>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="iso9001" name="standards[]" value="ISO9001 Quality" checked>
<label class="form-check-label text-muted" for="iso9001">ISO9001 Quality</label>
                </div>
<div class="form-check">
                    <input class="form-check-input" type="checkbox" id="iso14001" name="standards[]" value="ISO14001 Environmental" disabled>
                    <label class="form-check-label text-muted" for="iso14001">ISO14001 Environmental</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="iso27001" name="standards[]" value="ISO27001 Quality" disabled>
                    <label class="form-check-label text-muted" for="iso27001">ISO 27001 International</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="iso45001" name="standards[]" value="ISO 45001 Safety" disabled>
                    <label class="form-check-label text-muted" for="iso45001">ISO 45001 Safety</label>
                </div>
<div class="form-check">
                    <input class="form-check-input" type="checkbox" id="customStandard" name="standards[]" value="Custom" disabled>
                    <label class="form-check-label text-muted" for="customStandard">Integrated Management System IMS</label>
                </div>
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" id="customStandard" name="standards[]" value="Custom" disabled>
                    <label class="form-check-label text-muted" for="customStandard">Custom</label>
                </div>
grayed out = comin soon
            </div>
        </div>
<div class="container mt-5">
    <h3>Select an EA Code</h3>
    
    <div class="mt-3">

        <select class="form-select" id="eaCodeSelect">
            <option value="" selected disabled>-- Select an EA Code --</option>

            <optgroup label="Manufacturing Sectors">
                <option value="3">EA 3 – Food Products, Beverages, and Tobacco</option>
                <option value="4">EA 4 – Textiles and Textile Products</option>
                <option value="5">EA 5 – Leather and Leather Products</option>
                <option value="6">EA 6 – Wood and Wood Products</option>
                <option value="7">EA 7 – Pulp, Paper, and Paper Products</option>
                <option value="8">EA 8 – Publishing Companies</option>
                <option value="9">EA 9 – Printing Companies</option>
                <option value="10">EA 10 – Manufacture of Coke and Refined Petroleum Products</option>
                <option value="12">EA 12 – Chemicals, Chemical Products, and Fibers</option>
                <option value="13">EA 13 – Pharmaceuticals</option>
            </optgroup>

            <optgroup label="Service Sectors">
                <option value="28">EA 28 – Construction</option>
                <option value="29">EA 29 – Wholesale and Retail Trade</option>
                <option value="30">EA 30 – Hotels and Restaurants</option>
                <option value="31">EA 31 – Transport, Storage, and Communication</option>
                <option value="32">EA 32 – Financial Intermediation, Real Estate, Renting</option>
                <option value="33">EA 33 – Information Technology</option>
                <option value="34">EA 34 – Engineering Services</option>
                <option value="35">EA 35 – Other Services</option>
            </optgroup>

            <optgroup label="Other Industries">
                <option value="39">EA 39 – Other Social Services (Healthcare, Education)</option>
            </optgroup>
        </select>
    </div>
</div>
    </form>
</div>

                    <button class="btn btn-primary next-step" data-bs-target="#step2-tab" data-progress="25">Next</button>
                </div>
                <div class="tab-pane fade" id="step2" role="tabpanel">
                    <h3>Auditor Competencies</h3>
SEE PHOTOS

<?php

// Example pre-filled session variables (can be set dynamically)
$_SESSION['auditor_name'] = isset($_SESSION['auditor_name']) ? $_SESSION['auditor_name'] : 'John Doe';
$_SESSION['auditor_email'] = isset($_SESSION['auditor_email']) ? $_SESSION['auditor_email'] : 'johndoe@example.com';
$_SESSION['training'] = isset($_SESSION['training']) ? $_SESSION['training'] : '';
$_SESSION['education'] = isset($_SESSION['education']) ? $_SESSION['education'] : '';
$_SESSION['experience'] = isset($_SESSION['experience']) ? $_SESSION['experience'] : '';
?>

<div class="container mt-5">
    <form method="post" action="process_auditor.php">
        <!-- Auditor Information -->
        <div class="row">
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="auditorName" class="form-label"><strong>Auditor Name</strong></label>
                    <input type="text" class="form-control" id="auditorName" name="auditor_name" value="<?= htmlspecialchars($_SESSION['auditor_name']); ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="mb-3">
                    <label for="auditorEmail" class="form-label"><strong>Email</strong></label>
                    <input type="email" class="form-control" id="auditorEmail" name="auditor_email" value="<?= htmlspecialchars($_SESSION['auditor_email']); ?>">
                </div>
            </div>
        </div>

        <!-- Competencies Section -->
        <div class="row mt-3">
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="training" class="form-label"><strong>Training</strong></label>
                    <textarea class="form-control" id="training" name="training" rows="3"><?= htmlspecialchars($_SESSION['training']); ?></textarea>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="education" class="form-label"><strong>Education</strong></label>
                    <textarea class="form-control" id="education" name="education" rows="3"><?= htmlspecialchars($_SESSION['education']); ?></textarea>
                </div>
            </div>
            <div class="col-md-4">
                <div class="mb-3">
                    <label for="experience" class="form-label"><strong>Experience</strong></label>
                    <textarea class="form-control" id="experience" name="experience" rows="3"><?= htmlspecialchars($_SESSION['experience']); ?></textarea>
                </div>
            </div>
        </div>
    </form>
</div>





                    <button class="btn btn-secondary prev-step" data-bs-target="#step1-tab">Previous</button>
                    <button class="btn btn-primary next-step" data-bs-target="#step3-tab" data-progress="50">Next</button>
                </div>
                <div class="tab-pane fade" id="step3" role="tabpanel">
                    <h3>Report Settings</h3>
                    <button class="btn btn-secondary prev-step" data-bs-target="#step2-tab">Previous</button>
                    <button class="btn btn-primary next-step" data-bs-target="#step4-tab" data-progress="75">Next</button>
                </div>
                <div class="tab-pane fade" id="step4" role="tabpanel">
                    <h3>Terms</h3>
                    <button class="btn btn-secondary prev-step" data-bs-target="#step3-tab">Previous</button>
                    <button class="btn btn-success finish-step" data-progress="100">Finish</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
    let progressBar = document.getElementById('progressBar');
    let sessionProgress = parseInt(progressBar.getAttribute('aria-valuenow'));

    if (!isNaN(sessionProgress)) {
        progressBar.style.width = sessionProgress + '%';
        progressBar.innerText = sessionProgress + '%';

        // Select the next tab (not the current one)
        let nextTab;
        if (sessionProgress >= 100) {
            nextTab = document.querySelector('#step4-tab'); // Move to final tab
        } else if (sessionProgress >= 75) {
            nextTab = document.querySelector('#step4-tab'); // Move to Step 4
        } else if (sessionProgress >= 50) {
            nextTab = document.querySelector('#step3-tab'); // Move to Step 3
        } else if (sessionProgress >= 25) {
            nextTab = document.querySelector('#step2-tab'); // Move to Step 2
        } else {
            nextTab = document.querySelector('#step1-tab'); // Default first tab
        }

        if (nextTab) {
            let tabInstance = new bootstrap.Tab(nextTab);
            tabInstance.show();
        }
    }
});

document.querySelectorAll('.next-step, .finish-step').forEach(button => {
    button.addEventListener('click', function() {
        let target = this.getAttribute('data-bs-target');
        let progressScope = parseInt(this.getAttribute('data-progress'));

        let progressBar = document.getElementById('progressBar');
        let currentProgress = parseInt(progressBar.getAttribute('aria-valuenow'));

        // **Instantly update the progress bar visually**
        if (!isNaN(progressScope) && progressScope > currentProgress) {
            progressBar.style.width = progressScope + '%';
            progressBar.innerText = progressScope + '%';
            progressBar.setAttribute('aria-valuenow', progressScope);

            // Send update to the server asynchronously
            fetch('', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'progress_scope=' + progressScope
            })
            .then(response => response.text())
            .then(data => {
                let updatedProgress = parseInt(data.trim());

                if (!isNaN(updatedProgress)) {
                    progressBar.style.width = updatedProgress + '%';
                    progressBar.innerText = updatedProgress + '%';
                    progressBar.setAttribute('aria-valuenow', updatedProgress);

                    // Automatically move to the NEXT step
                    let nextTab;
                    if (updatedProgress >= 100) {
                        nextTab = document.querySelector('#step4-tab');
                    } else if (updatedProgress >= 75) {
                        nextTab = document.querySelector('#step4-tab');
                    } else if (updatedProgress >= 50) {
                        nextTab = document.querySelector('#step3-tab');
                    } else if (updatedProgress >= 25) {
                        nextTab = document.querySelector('#step2-tab');
                    }

                    if (nextTab) {
                        let tabInstance = new bootstrap.Tab(nextTab);
                        tabInstance.show();
                    }
                } else {
                    console.error("Invalid progress value received: " + data);
                }
            })
            .catch(error => console.error('Error:', error));
        }

        // Ensure the correct tab is immediately visible when clicked
        if (target) {
            let tabInstance = new bootstrap.Tab(document.querySelector(target));
            tabInstance.show();
        }
    });
});

</script>

<?php include 'inc.footer.php'; ?>
