<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Audit Tutorials - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Ensure the body takes up the full height of the viewport */
    html, body {
      height: 100%;
      margin: 0;
    }
    /* Content wrapper with padding to prevent overlap with the footer */
    .content-wrapper {
      padding: 20px;
      padding-bottom: 100px; /* Add padding equal to the footer height */
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
      /*height: 100px;  Fixed height for the footer */
      border-top: 1px solid #dee2e6; /* Add a border to the top of the footer */
      position: fixed; /* Make the footer sticky */
      bottom: 0; /* Stick it to the bottom */
      left: 0;
      right: 0;
      z-index: 1000; /* Ensure the footer stays above other content */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.01);
    }
    /* Active state for the footer section */
    footer .footer-section.active {
      border-top: 4px solid #ffffff; /* White border to indicate active state */
      box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1); /* Subtle shadow for emphasis */
    }
    /* Tutorial card styling */
    .tutorial-card {
      margin-bottom: 20px;
      border: 1px solid #dee2e6;
      border-radius: 8px;
      overflow: hidden;
    }
    .tutorial-card img {
      width: 100%;
      height: 200px;
      object-fit: cover;
    }
    .tutorial-card .card-body {
      padding: 20px;
    }
    /* Live Help section styling */
    .live-help-section {
      background-color: #f8f9fa;
      padding: 20px;
      border-radius: 8px;
      margin-bottom: 20px;
    }
    .live-help-section h5 {
      margin-bottom: 15px;
      font-weight: bold;
    }
    .live-help-section .btn {
      margin-right: 10px;
      margin-bottom: 10px;
    }
  </style>
</head>
<body>
  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          <a class="btn btn-outline-secondary me-2" href="alerts.php">
            <i class="fa-solid fa-bell"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Tutorials Content -->
  <div class="content-wrapper">
    <!-- Live Help Section -->
    <div class="live-help-section">
      <h5>Need Live Help?</h5>
      <p>Get immediate assistance from our experts via call, video chat, or in-person support.</p>
      <div>
        <button class="btn btn-primary">
          <i class="fa-solid fa-phone me-2"></i> Call Support
        </button>
        <button class="btn btn-success">
          <i class="fa-solid fa-video me-2"></i> Video Chat
        </button>
        <button class="btn btn-warning">
          <i class="fa-solid fa-user me-2"></i> In-Person Support
        </button>
      </div>
    </div>

    <!-- Tutorials Section -->
    <div class="card mb-4">
      <div class="card-header d-flex justify-content-between align-items-center">
        <div>
          <h5 class="mb-0">Audit Tutorials</h5>
          <small class="text-muted">Learn how to conduct audits effectively</small>
        </div>
      </div>
      <div class="card-body">
        <!-- Tutorial Cards -->
        <div class="row">
          <!-- Tutorial 1 -->
          <div class="col-md-4">
            <div class="tutorial-card">
              <img src="https://placehold.co/600x400" alt="Tutorial 1">
              <div class="card-body">
                <h6 class="card-title">Introduction to ISO 9001</h6>
                <p class="card-text">Learn the basics of ISO 9001 and how to implement it in your organization.</p>
                <a href="#" class="btn btn-primary">Start Tutorial</a>
              </div>
            </div>
          </div>

          <!-- Tutorial 2 -->
          <div class="col-md-4">
            <div class="tutorial-card">
              <img src="https://placehold.co/600x400" alt="Tutorial 2">
              <div class="card-body">
                <h6 class="card-title">Audit Planning and Preparation</h6>
                <p class="card-text">Discover how to plan and prepare for a successful audit.</p>
                <a href="#" class="btn btn-primary">Start Tutorial</a>
              </div>
            </div>
          </div>

          <!-- Tutorial 3 -->
          <div class="col-md-4">
            <div class="tutorial-card">
              <img src="https://placehold.co/600x400" alt="Tutorial 3">
              <div class="card-body">
                <h6 class="card-title">Conducting Effective Audits</h6>
                <p class="card-text">Master the skills needed to conduct audits efficiently and effectively.</p>
                <a href="#" class="btn btn-primary">Start Tutorial</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer>
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors</div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center active">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Help</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>