<?php
// Start session
session_start();

// Secret key (same as the one used to generate the hash)
$secret_key = 'your_secret_key_here'; // Use the same secure key

// Ensure the key and hash are provided in the URL
if (isset($_GET['key']) && isset($_GET['hash'])) {
    $unique_number = $_GET['key'];
    $hash_from_url = $_GET['hash'];

    // Validate that the key and hash are of expected lengths (optional but recommended)
    if (strlen($unique_number) < 32 || strlen($hash_from_url) != 64) {
        echo "Invalid access. The link is not valid.";
        exit();
    }

    // Recompute the HMAC (hash) using the unique number and secret key
    $computed_hmac = hash_hmac('sha256', $unique_number, $secret_key);

    // Use hash_equals() to safely compare the computed hash with the hash from the URL
    if (hash_equals($computed_hmac, $hash_from_url)) {
        // Hash is valid, grant access to the dashboard
        $_SESSION['companyName'] = 'Acme, Inc.'; // Example session variable
        header("Location: dashboard.php");
        exit();
    } else {
        // Invalid hash, deny access
        echo "Invalid access. The link is not valid.";
        exit();
    }
} else {
    // No key or hash provided, deny access
    echo "No access key or hash provided.";
    exit();
}
?>
