<?php 

$title = "New Audit";
$slug="template";

include 'inc.header.php'; ?>

<div class="container"><div class="row"><div class="col-md-12">


<h1 class="text-center mt-5">Start a New Audit</h1>

<form method="post" action="audit-new-process.php">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="companyName" class="form-label"><strong>Company Name</strong></label>
                                <input type="text" class="form-control" id="companyName" name="company_name" value="<?php echo isset($_SESSION['companyName']) ? htmlspecialchars($_SESSION['companyName'], ENT_QUOTES) : ''; ?>">
                            </div>
                            <div class="mb-3">
                                <label for="auditorId" class="form-label"><strong>Auditor ID</strong></label>
                                <input type="text" class="form-control" id="auditorId" name="auditor_id">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="address" class="form-label"><strong>Address</strong></label>
                                <input type="text" class="form-control" id="address" name="address">
                            </div>
                            <div class="mb-3">
                                <label for="cityStateZip" class="form-label"><strong>City, State, ZIP</strong></label>
                                <div class="d-flex">
                                    <input type="text" class="form-control me-2" id="city" name="city" placeholder="City">
                                    <input type="text" class="form-control me-2" id="state" name="state" placeholder="State">
                                    <input type="text" class="form-control" id="zip" name="zip" placeholder="ZIP">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Site Type</strong></label><br>
                                <div class="form-check">
    <input class="form-check-input" type="radio" id="singleSite" name="site_type" value="single">
    <label class="form-check-label" for="singleSite" style="font-size: 1.2em;">Single Site</label>
</div>
<div class="form-check">
    <input class="form-check-input" type="radio" id="multipleSites" name="site_type" value="multiple">
    <label class="form-check-label" for="multipleSites" style="font-size: 1.2em;">Multiple Sites</label>
</div>

                            </div>
                        </div>
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Audit Type</strong></label><br>
                                <div class="form-check">
    <input class="form-check-input" type="radio" id="internalAudit" name="audit_type" value="internal">
    <label class="form-check-label" for="internalAudit" style="font-size: 1.2em;">Internal</label>
</div>
<div class="form-check">
    <input class="form-check-input" type="radio" id="supplyChainAudit" name="audit_type" value="supplyChain">
    <label class="form-check-label" for="supplyChainAudit" style="font-size: 1.2em;">Supply Chain</label>
</div>

                            </div>
                        </div>
                        <div class="col-md-4 delimited-section">
                            <div class="mb-3">
                                <label class="form-label"><strong>Standards</strong></label><br>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso9001" name="standards[]" value="ISO9001 Quality">
                                    <label class="form-check-label" for="iso9001" style="font-size: 1.2em;">ISO9001 Quality</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso27001" name="standards[]" value="ISO27001 Quality">
                                    <label class="form-check-label" for="iso27001" style="font-size: 1.2em;">ISO 27001 International</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso45001" name="standards[]" value="ISO 45001 Safety">
                                    <label class="form-check-label" for="iso45001" style="font-size: 1.2em;">ISO 45001 Safety</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="iso14001" name="standards[]" value="ISO14001 Environmental">
                                    <label class="form-check-label" for="iso14001" style="font-size: 1.2em;">ISO14001 Environmental</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="customStandard" name="standards[]" value="Custom">
                                    <label class="form-check-label" for="customStandard" style="font-size: 1.2em;">Custom</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-secondary w-100 mt-3">Submit</button>
                </form>

</div></div></div>
<br><br>
<?php include 'inc.footer.php';
