<?php 

$title = "Title";
$slug="template";

include 'inc.header.php'; ?>

<div class="container"><div class="row"><div class="col-md-12">


<h1 class="text-center mt-5"><?php echo $_SESSION['companyName']; ?></h1>

    <?php include 'inc.db.php'; ?>
    <div class="row">
        <!-- Left Column: Auditor Competency Form -->
        <div class="col-md-6">
            <h3 class="mb-4">Auditor Competency Form</h3>
            <form method="post" action="process_auditor.php">
                <div class="mb-3">
                    <label for="auditorName" class="form-label"><strong>Auditor Name</strong></label>
                    <input type="text" class="form-control" id="auditorName" name="auditor_name" required>
                </div>

                <div class="mb-3">
                    <label for="auditorEmail" class="form-label"><strong>Email</strong></label>
                    <input type="email" class="form-control" id="auditorEmail" name="auditor_email" required>
                </div>

                <div class="mb-3">
                    <label for="auditorPhone" class="form-label"><strong>Phone Number</strong></label>
                    <input type="tel" class="form-control" id="auditorPhone" name="auditor_phone" required>
                </div>

                <div class="mb-3">
                    <label for="auditorEducation" class="form-label"><strong>Select Your Highest Level of Education:</strong></label>
                    <select class="form-select" id="auditorEducation" name="education_level" required>
                        <option value="" selected disabled>-- Select One --</option>
                        <optgroup label="General Education">
                            <option value="below_high_school">Below High School</option>
                            <option value="high_school">High School Diploma or GED</option>
                            <option value="some_college">Some College (No Degree)</option>
                        </optgroup>
                        <optgroup label="Higher Education">
                            <option value="associate_degree">Associate Degree (2-Year)</option>
                            <option value="trade_school">Trade or Technical School</option>
                            <option value="bachelor_degree">Bachelor’s Degree (4-Year)</option>
                            <option value="advanced_degree">Master’s or Doctoral Degree</option>
                        </optgroup>
                        <optgroup label="Specialized Training">
                            <option value="audit_training">Audit Training / Certification</option>
                            <option value="other_specialized_training">Other Specialized Training</option>
                        </optgroup>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="certifications" class="form-label"><strong>Certifications</strong></label>
                    <textarea class="form-control" id="certifications" name="certifications" rows="2" required></textarea>
                </div>

                <div class="mb-3">
                    <label for="experience" class="form-label"><strong>Audit Experience</strong></label>
                    <textarea class="form-control" id="experience" name="experience" rows="3" required></textarea>
                </div>

                <div class="mb-3">
                    <label for="training" class="form-label"><strong>Training & Courses Completed</strong></label>
                    <textarea class="form-control" id="training" name="training" rows="3" required></textarea>
                </div>

                <div class="mb-3">
                    <label for="technicalExpertise" class="form-label"><strong>Technical Expertise</strong></label>
                    <textarea class="form-control" id="technicalExpertise" name="technical_expertise" rows="3" required></textarea>
                </div>

                <div class="mb-3">
                    <label for="competencyAssessment" class="form-label"><strong>Competency Assessment</strong></label>
                    <textarea class="form-control" id="competencyAssessment" name="competency_assessment" rows="3" required></textarea>
                </div>

                <button type="submit" class="btn btn-primary w-100">Submit Competency</button>
            </form>
        </div>

        <!-- Right Column: List of Auditors -->
        <div class="col-md-6">
            <h3 class="mb-4">Registered Auditors</h3>
            <div class="list-group" id="auditorList">
                <?php
                $result = $conn->query("SELECT auditor_name, auditor_email, education_level FROM auditor_competencies ORDER BY auditor_name");
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo '<div class="list-group-item">';
                        echo '<h5 class="mb-1">' . htmlspecialchars($row["auditor_name"]) . '</h5>';
                        echo '<p class="mb-1"><strong>Email:</strong> ' . htmlspecialchars($row["auditor_email"]) . '</p>';
                        echo '<small><strong>Education:</strong> ' . htmlspecialchars(str_replace('_', ' ', ucfirst($row["education_level"]))) . '</small>';
                        echo '</div>';
                    }
                } else {
                    echo '<p class="text-muted">No auditors registered yet.</p>';
                }
                ?>
            </div>
        </div>
    </div>




</div></div></div>

<?php include 'inc.footer.php';
