<?php 
error_reporting(E_ALL);
ini_set('display_errors', 1);

$title = "Manage Auditors";
$slug = "manage-auditors";

include 'inc.header.php';
include 'config.php'; // Database connection


$company_id = $_SESSION['user_id'];
$message = "";

// Debugging session variables
var_dump($_SESSION);

// Handle adding auditors
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['add_auditor'])) {
        $auditor_id = intval($_POST['auditor_id']);
        
        // Prevent duplicate entries
        $check_stmt = $conn->prepare("SELECT * FROM company_auditors WHERE user_id = ? AND auditor_id = ?");
        $check_stmt->bind_param("ii", $company_id, $auditor_id);
        $check_stmt->execute();
        if ($check_stmt->get_result()->num_rows > 0) {
            $message = "<div class='alert alert-warning'>This auditor is already assigned.</div>";
        } else {
            $stmt = $conn->prepare("INSERT INTO company_auditors (company_id, auditor_id, added_by) VALUES (?, ?, ?)");
            $stmt->bind_param("iii", $company_id, $auditor_id, $_SESSION['user_id']);
            if ($stmt->execute()) {
                $message = "<div class='alert alert-success'>Auditor added successfully.</div>";
            } else {
                $message = "<div class='alert alert-danger'>Error adding auditor.</div>";
            }
        }
    }

    if (isset($_POST['remove_auditor'])) {
        $auditor_id = intval($_POST['auditor_id']);
        $stmt = $conn->prepare("DELETE FROM company_auditors WHERE company_id = ? AND auditor_id = ?");
        $stmt->bind_param("ii", $company_id, $auditor_id);
        if ($stmt->execute()) {
            $message = "<div class='alert alert-success'>Auditor removed successfully.</div>";
        } else {
            $message = "<div class='alert alert-danger'>Error removing auditor.</div>";
        }
    }
}

// Fetch assigned auditors
$auditors_stmt = $conn->prepare("
    SELECT u.id, u.first_name, u.last_name, u.email 
    FROM myisopro_users u
    JOIN company_auditors ca ON u.id = ca.auditor_id
    WHERE ca.company_id = ?
");
$auditors_stmt->bind_param("i", $company_id);
$auditors_stmt->execute();
$auditors = $auditors_stmt->get_result();

// Debug auditors
var_dump($auditors->num_rows);

// Fetch available auditors
$available_auditors_stmt = $conn->prepare("
    SELECT id, first_name, last_name, email 
    FROM myisopro_users 
    WHERE id NOT IN (SELECT auditor_id FROM company_auditors WHERE company_id = ?)
");
$available_auditors_stmt->bind_param("i", $company_id);
$available_auditors_stmt->execute();
$available_auditors = $available_auditors_stmt->get_result();
?>

<div class="container">
    <div class="row">
        <div class="col-md-12">
            <h1 class="text-center mt-5"><?php echo $_SESSION['company_name']; ?></h1>
            <?= $message; ?>

            <!-- Add Auditor Form -->
            <div class="card my-4">
                <div class="card-header">Add Auditor</div>
                <div class="card-body">
                    <form method="POST">
                        <div class="mb-3">
                            <label for="auditor_id" class="form-label">Select Auditor</label>
                            <select class="form-select" name="auditor_id" required>
                                <option value="">-- Choose Auditor --</option>
                                <?php while ($row = $available_auditors->fetch_assoc()): ?>
                                    <option value="<?= $row['id']; ?>">
                                        <?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name'] . ' (' . $row['email'] . ')'); ?>
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                        <button type="submit" name="add_auditor" class="btn btn-primary">Add Auditor</button>
                    </form>
                </div>
            </div>

            <!-- List Auditors -->
            <div class="card">
                <div class="card-header">Assigned Auditors</div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($row = $auditors->fetch_assoc()): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['first_name'] . ' ' . $row['last_name']); ?></td>
                                    <td><?= htmlspecialchars($row['email']); ?></td>
                                    <td>
                                        <form method="POST" class="d-inline">
                                            <input type="hidden" name="auditor_id" value="<?= $row['id']; ?>">
                                            <button type="submit" name="remove_auditor" class="btn btn-danger btn-sm">Remove</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                    <?php if ($auditors->num_rows == 0): ?>
                        <p class="text-center text-muted">No auditors assigned yet.</p>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>
</div>

<?php include 'inc.footer.php'; ?>
