<?php
session_start();

// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'config.php'; // Include the centralized database connection

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect form data
    $firstName = $_SESSION['firstName'] = $_POST['firstName'];
    $lastName = $_SESSION['lastName'] = $_POST['lastName'];
    $companyName = $_SESSION['companyName'] = $_POST['companyName'];
    $phone = $_SESSION['phone'] = $_POST['phone'];
    $email = $_SESSION['email'] = $_POST['email'];
    
    // Address fields
    $address = $_SESSION['address'] = $_POST['address'];
    $city = $_SESSION['city'] = $_POST['city'];
    $state = $_SESSION['state'] = $_POST['state'];
    $zip = $_SESSION['zip'] = $_POST['zip'];
    $country = $_SESSION['country'] = $_POST['country'];

    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);

    // Check if email already exists
    $check_sql = "SELECT id FROM myisopro_users WHERE email = ?";
    if ($check_stmt = $conn->prepare($check_sql)) {
        $check_stmt->bind_param("s", $email);
        $check_stmt->execute();
        $check_stmt->store_result();
        
        if ($check_stmt->num_rows > 0) {
            // Email already exists
            $_SESSION['message'] = 'alreadyregistered';
            header("Location: ../register.php");
            exit();
        } else {
            // Set trial start date and initial subscription status
            $trial_start = date("Y-m-d H:i:s");  // Current timestamp as trial start date
            $subscription_status = 'trial';  // Initial status set to 'trial'

            // Insert user data including trial start, subscription status, and address
            $sql = "INSERT INTO myisopro_users (first_name, last_name, company_name, phone, email, password, trial_start, subscription_status, address, city, state, zip, country) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            if ($stmt = $conn->prepare($sql)) {
                $stmt->bind_param("sssssssssssss", $firstName, $lastName, $companyName, $phone, $email, $password, $trial_start, $subscription_status, $address, $city, $state, $zip, $country);

                // Execute and check for success
                if ($stmt->execute()) {
                    // Send welcome email
                    $subject = "Welcome to MyIsoPro!";
                    $loginUrl = "https://myisopro.com/login.php"; // Fixed login link

                    // HTML email message
                    $message = "
                    <html>
                    <head>
                        <title>Welcome to MyIsoPro</title>
                    </head>
                    <body>
                        <h2>Welcome, $firstName $lastName!</h2>
                        <p>Thank you for registering with MyIsoPro. Your account has been successfully created and you are on a 30-day free trial.</p>
                        <p><strong>Your login details:</strong></p>
                        <ul>
                            <li><strong>Email (Username):</strong> $email</li>
                            <li><strong>Company:</strong> $companyName</li>
                            <li><strong>Phone:</strong> $phone</li>
                            <li><strong>Address:</strong> $address, $city, $state, $zip, $country</li>
                        </ul>
                        <p>To log in, please click the following link:</p>
                        <p><a href='$loginUrl'>$loginUrl</a></p>
                        <p>Best regards,<br>The MyIsoPro Team</p>
                    </body>
                    </html>
                    ";

                    // Set email headers for HTML email
                    $headers = "MIME-Version: 1.0" . "\r\n";
                    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
                    $headers .= "From: noreply@myisopro.com" . "\r\n";

                    // Send the email and provide feedback
                    if (mail($email, $subject, $message, $headers)) {
                        $_SESSION['message'] = 'accountcreated';
                        header("Location: ../login.php"); // Redirect to login page
                        exit();
                    } else {
                        echo "Account created, but there was an error sending the welcome email.";
                    }
                } else {
                    // Error executing statement
                    echo "Error executing statement: " . $stmt->error;
                }
                $stmt->close();
            } else {
                echo "Error preparing statement: " . $conn->error;
            }
        }
        $check_stmt->close();
    } else {
        echo "Error preparing email check statement: " . $conn->error;
    }

    $conn->close();
}
?>
