<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Choose Audit Type - MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Ensure the body takes up the full height of the viewport */
    html, body {
      height: 100%;
      margin: 0;
    }
    /* Content wrapper with padding to prevent overlap with the footer */
    .content-wrapper {
      padding: 20px;
      padding-bottom: 80px; /* Add padding to prevent footer overlap */
    }
    /* Enlarged brand title styling */
    .brand-title {
      font-size: 28px;
      font-weight: bold;
      letter-spacing: 1px;
    }
    .brand-title .iso {
      color: #34A853;
      font-weight: bold;
      text-transform: uppercase;
    }
    .brand-title .globe-icon {
      font-size: 28px;
      color: #34A853;
    }
    /* Footer styles with matching step button colors */
    footer {
      background-color: #f8f9fa; /* Light gray background for contrast */
      /*height: 100px;  Fixed height for the footer */
      border-top: 1px solid #dee2e6; /* Add a border to the top of the footer */
      position: fixed; /* Make the footer sticky */
      bottom: 0; /* Stick it to the bottom */
      left: 0;
      right: 0;
      z-index: 1000; /* Ensure the footer stays above other content */
    }
    footer .footer-section a {
      display: block;
      text-align: center;
      padding: 10px 0;
      color: white;
      text-decoration: none;
      font-size: 18px;
    }
    .footer1 { background-color: #6f42c1; } /* Step 1 - Purple */
    .footer2 { background-color: #1e88e5; } /* Step 2 - Blue */
    .footer3 { background-color: #2e7d32; } /* Step 3 - Green */
    .footer4 { background-color: #fb8c00; } /* Step 4 - Orange */
    footer .footer-section:hover {
      opacity: 0.8;
      transform: scale(1.01);
    }
    /* Active state for the footer section */
    footer .footer-section.active {
      border-top: 4px solid #ffffff; /* White border to indicate active state */
      box-shadow: 0 -4px 6px rgba(0, 0, 0, 0.1); /* Subtle shadow for emphasis */
    }
    /* Audit type card styling */
    .audit-type-card {
      background-color: #f8f9fa;
      border: 1px solid #dee2e6;
      border-radius: 8px;
      padding: 20px;
      text-align: center;
      cursor: pointer;
      transition: all 0.3s ease;
      margin-bottom: 20px;
    }
    .audit-type-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    .audit-type-card.disabled {
      opacity: 0.5;
      cursor: not-allowed;
    }
    .audit-type-card h3 {
      font-size: 24px;
      font-weight: bold;
      margin-bottom: 10px;
    }
    .audit-type-card p {
      font-size: 16px;
      color: #6c757d;
    }
  </style>
</head>
<body>
  <!-- Navigation Bar with 3 icons on each side -->
  <nav class="navbar navbar-light bg-light">
    <div class="container-fluid">
      <div class="row w-100 align-items-center">
        <div class="col-4 d-flex align-items-center">
          <a class="btn btn-outline-secondary me-2" href="dashboard.php">
            <i class="fa-solid fa-home"></i>
          </a>
          <a class="btn btn-outline-secondary me-2" href="audit-reports.php">
            <i class="fa-solid fa-clipboard-list"></i>
          </a>
        </div>
        <div class="col-4 d-flex justify-content-center align-items-center mx-auto px-0 text-center position-absolute start-50 top-50 translate-middle">
          <span class="navbar-brand mb-0 h1 brand-title">
            My<span class="iso">IS</span><span class="globe-icon"><i class="fa-solid fa-globe"></i></span>Pro
          </span>
        </div>
        <div class="col-4 d-flex justify-content-end ms-auto pe-0">
          <a class="btn btn-outline-secondary me-2" href="alerts.php">
            <i class="fa-solid fa-bell"></i>
          </a>
          <a class="btn btn-outline-secondary" href="logout.php">
            <i class="fa-solid fa-right-from-bracket"></i>
          </a>
        </div>
      </div>
    </div>
  </nav>

  <!-- Choose Audit Type Content -->
  <div class="content-wrapper">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <h1 class="text-center mt-3"><?php echo $_SESSION['companyName']; ?></h1>
          <h2 class="mb-4">Choose Audit Type</h2>
          <p>Select the type of audit you want to perform. Currently, only ISO 9001 is available.</p>
          <div class="row">
            <!-- ISO 9001 Card -->
            <div class="col-md-4">
              <div class="audit-type-card" onclick="window.location.href='new-audit.php';">
                <h3>ISO 9001</h3>
                <p>Quality Management System</p>
              </div>
            </div>
            <!-- ISO 14001 Card (Disabled) -->
            <div class="col-md-4">
              <div class="audit-type-card disabled">
                <h3>ISO 14001</h3>
                <p>Environmental Management System</p>
              </div>
            </div>
            <!-- ISO 45001 Card (Disabled) -->
            <div class="col-md-4">
              <div class="audit-type-card disabled">
                <h3>ISO 45001</h3>
                <p>Occupational Health and Safety</p>
              </div>
            </div>
            <!-- ISO 27001 Card (Disabled) -->
            <div class="col-md-4">
              <div class="audit-type-card disabled">
                <h3>ISO 27001</h3>
                <p>Information Security Management</p>
              </div>
            </div>
            <!-- ISO 22000 Card (Disabled) -->
            <div class="col-md-4">
              <div class="audit-type-card disabled">
                <h3>ISO 22000</h3>
                <p>Food Safety Management</p>
              </div>
            </div>
            <!-- ISO 50001 Card (Disabled) -->
            <div class="col-md-4">
              <div class="audit-type-card disabled">
                <h3>ISO 50001</h3>
                <p>Energy Management System</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

    <!-- Sticky Footer with 4 clickable sections matching step button colors -->
  <footer>
    <div class="container-fluid">
      <div class="row">
        <div class="col footer-section footer1 text-center">
          <a href="customize-myisopro.php">
            <i class="fa-solid fa-cogs fa-lg"></i>
            <div>Customize MyISOPro - 65%</div>
          </a>
        </div>
        <div class="col footer-section footer2 text-center">
          <a href="auditors.php">
            <i class="fa-solid fa-user-check fa-lg"></i>
            <div>Add Auditors</div>
          </a>
        </div>
        <div class="col footer-section footer3 text-center">
          <a href="audit-help.php">
            <i class="fa-solid fa-question fa-lg"></i>
            <div>Audit Help</div>
          </a>
        </div>
        <div class="col footer-section footer4 text-center">
          <a href="completed-audits.php">
            <i class="fa-solid fa-clipboard-list fa-lg"></i>
            <div>Completed Audits</div>
          </a>
        </div>
      </div>
    </div>
  </footer>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>