<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Welcome to MyISOPro</title>
  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    /* Ensure the body takes up the full height of the viewport */
    html, body {
      height: 100%;
      margin: 0;
    }
    /* Center content vertically and horizontally */
    .welcome-container {
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      height: 100%;
      text-align: center;
      padding: 20px;
      background-color: #f8f9fa; /* Light gray background */
    }
    .welcome-title {
      font-size: 2.5rem;
      font-weight: bold;
      color: #34A853; /* MyISOPro brand color */
      margin-bottom: 20px;
    }
    .welcome-subtitle {
      font-size: 1.2rem;
      color: #6c757d; /* Subdued text color */
      margin-bottom: 40px;
    }
    .task-list {
      text-align: left;
      margin-bottom: 40px;
    }
    .task-item {
      display: flex;
      align-items: center;
      margin-bottom: 15px;
      font-size: 1.1rem;
    }
    .task-item i {
      margin-right: 10px;
      color: #34A853; /* MyISOPro brand color */
    }
    .get-started-btn {
      padding: 10px 30px;
      font-size: 1.2rem;
      background-color: #34A853; /* MyISOPro brand color */
      border: none;
      color: white;
      border-radius: 5px;
      cursor: pointer;
      transition: background-color 0.3s ease;
    }
    .get-started-btn:hover {
      background-color: #2e7d32; /* Darker green on hover */
    }
  </style>
</head>
<body>
  <!-- Welcome Container -->
  <div class="welcome-container">
    <div class="welcome-content">
      <!-- Welcome Title -->
      <h1 class="welcome-title">Welcome to MyISOPro!</h1>
      <!-- Welcome Subtitle -->
      <p class="welcome-subtitle">
        We're excited to have you on board. Let's get started by completing a few quick tasks to set up your account.
      </p>
      <!-- Task List -->
      <div class="task-list">
        <div class="task-item">
          <i class="fa-solid fa-cogs"></i>
          <span>Customize MyISOPro to fit your organization's needs.</span>
        </div>
        <div class="task-item">
          <i class="fa-solid fa-user-check"></i>
          <span>Add your team members and assign roles.</span>
        </div>
        <div class="task-item">
          <i class="fa-solid fa-clipboard-list"></i>
          <span>Set up your first audit and start tracking compliance.</span>
        </div>
      </div>
      <!-- Get Started Button -->
      <button class="get-started-btn" onclick="window.location.href='customize-myisopro.php'">
        Get Started
      </button>
    </div>
  </div>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>